%% Load Data from AH
% Erin Henry
% June 2024

% Calendar
n_period = 1;
[T,calvec,calds] = calendar_make([1947 1],[2018 1],n_period);

% FROM BEA MAKE USE TABLES
fname       = 'IOaccounting_1947to2018_5sec_MUXshares';        % older data (April 2024)
fname       = [datadir fname '.mat'];
load(fname, 'nI', 'theta', 'gamma', 'omega', 'phi', 'psiX', 'psiNX',...
            'psiG', 'vv', 'ee', 'tt', 'mm', 'xx', 'SecName','FDName');

% Save Variables
nS      = nI;
years   = tt;
sV_mat  = vv'./sum(vv)'; 
clear nI tt;
theta   = theta';
gamma   = gamma';
psiX    = psiX';
psiNX   = psiNX';
psiG    = psiG';
SecName{5} = 'Services';

% FROM KLEMS
fname1      = 'KLEMSbea_5sec_1947to2021';              % older data (April 2024)
fname1      = [datadir fname1 '.mat'];
load(fname1,'y', 'yq','v','vq','m','mq','k','kq','n','nq');
y   = y(1:T,:);
yq  = yq(1:T,:);
v   = v(1:T,:);
vq  = vq(1:T,:);
m   = m(1:T,:);
mq  = mq(1:T,:);
k   = k(1:T,:);
kq  = kq(1:T,:);
n   = n(1:T,:);
nq  = nq(1:T,:);


nq      = nq/100;
alpha   = k./v;

% Compute TFP
% Construct TFP Growth
d_tfp = NaN(T,nS);
for i = 2:T
    d_tfp(i,:) = (log(vq(i,:))-log(vq(i-1,:))) - alpha(i,:).*(log(kq(i,:))-...
        log(kq(i-1,:))) - (ones(1,nS)-alpha(i,:)).*(log(nq(i,:))-log(nq(i-1,:)));
end


% Variable list
% T: Full Sample size
% nS: Number of sectors
% gamma_mat: gamma (TxnS matrix)
% Omega_mat: Omega (nSxnSxT matrix)
% Phi_mat: Phi (nSxnSxT matrix)
% SecName: Sector Names (nSx1 string vector)
% FDName: Final Demand Names (nIxnS string vector)

% more:
% qq(i,t) gross output in sector i in period t
% vv(i,t) value added in sector i 
% mm(j,i,t) intermediate goods produced by j for i
% xx(j,i,t) investment produced by j for i
% ee(j,k,t) final demand component k produced by j, components described in FDName{k}  

% gamma(j,t)=vv(j,t)/qq(j,t): VA shares in gross output of sector j
% phi(j,i,t)=mm(j,i,t)/sum(mm(j,i,t),j): intermediate input requirements of sector i
% omega(j,i,t)=xx(j,i,t)/sum(xx(j,i,t),j): investment input requirements of sector i 
